/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.command.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2960;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class ToolStatArgument<T extends IToolStat>
implements ArgumentType<T> {
    private static final Collection<String> EXAMPLES = Arrays.asList("tconstruct:mining_speed", "tconstruct:durability");
    private static final DynamicCommandExceptionType NOT_FOUND = new DynamicCommandExceptionType(name -> TConstruct.makeTranslation("command", "stat_type.not_found", name));
    private static final Dynamic2CommandExceptionType WRONG_TYPE = new Dynamic2CommandExceptionType((name, clazz) -> TConstruct.makeTranslation("command", "stat_type.wrong_type", name, clazz));
    private final Class<T> filter;

    public static ToolStatArgument<IToolStat> stat() {
        return ToolStatArgument.stat(IToolStat.class);
    }

    public static IToolStat<?> getStat(CommandContext<class_2168> context, String name) {
        return (IToolStat)context.getArgument(name, IToolStat.class);
    }

    public T parse(StringReader reader) throws CommandSyntaxException {
        ToolStatId name = new ToolStatId(class_2960.method_12835((StringReader)reader));
        IToolStat<?> stat = ToolStats.getToolStat(name);
        if (stat == null) {
            throw NOT_FOUND.createWithContext((ImmutableStringReader)reader, (Object)name);
        }
        if (!this.filter.isInstance(stat)) {
            throw WRONG_TYPE.createWithContext((ImmutableStringReader)reader, (Object)name, (Object)this.filter.getSimpleName());
        }
        return (T)((IToolStat)this.filter.cast(stat));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9270(ToolStats.getAllStats().stream().filter(this.filter::isInstance).map(IToolStat::getName)::iterator, (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private ToolStatArgument(Class<T> filter) {
        this.filter = filter;
    }

    public static <T extends IToolStat> ToolStatArgument<T> stat(Class<T> filter) {
        return new ToolStatArgument<T>(filter);
    }
}

